unit Demobwcc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Toggler, StdCtrls, Custbtn;

type
  TBWCCControls = class(TForm)
    GroupBox1: TGroupBox;
    rbBlack: TBWCCRadioButton;
    rbNavy: TBWCCRadioButton;
    chkGross: TBWCCCheckBox;
    ShadowButton1: TShadowButton;
    rbMaroon: TBWCCRadioButton;
    rbGreen: TBWCCRadioButton;
    procedure FormActivate(Sender: TObject);
    procedure chkGrossClick(Sender: TObject);
    procedure rbClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BWCCControls: TBWCCControls;

implementation

{$R *.DFM}
uses
  DemoMain;

procedure TBWCCControls.FormActivate(Sender: TObject);
begin
  chkGross.Checked := not FrontPanel.BWCCBtn.Bitmap.Empty;
end;

procedure TBWCCControls.chkGrossClick(Sender: TObject);
begin
  if chkGross.Checked then
    FrontPanel.LoadGrossBitmaps
  else
    FrontPanel.UnloadGrossBitmaps;
end;

procedure TBWCCControls.rbClick(Sender: TObject);
var
  col: TColor;
begin
  if Sender = rbBlack then
    col := clBlack
  else if Sender = rbNavy then
    col := clNavy
  else if Sender = rbMaroon then
    col := clMaroon
  else
    col := clGreen;

  (Sender as TBWCCRadioButton).CheckColor := col;
  chkGross.CheckColor := col;
end;

end.
